<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SectionsSettingResource\Pages;
use App\Filament\Resources\SectionsSettingResource\RelationManagers;
use App\Models\SectionsSetting;
use App\Models\WebsiteSetting;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\Toggle;

class SectionsSettingResource extends Resource
{
    protected static ?string $model = WebsiteSetting::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
              // ======================
                // 🧩 Section Visibility
                // ======================
                Forms\Components\Section::make('Website Sections Visibility')
                    ->description('Control which sections appear on your website.')
                    ->schema([
                        Toggle::make('show_header_section')->label('Show Header')->inline(false),
                        Toggle::make('show_banner_section')->label('Show Banner')->inline(false),
                        Toggle::make('show_team_member_section')->label('Show Team Members')->inline(false),
                        Toggle::make('show_team_skills_section')->label('Show Team Skills')->inline(false),
                        Toggle::make('show_services_section')->label('Show Services')->inline(false),
                        Toggle::make('show_blog_section')->label('Show Blog')->inline(false),
                        Toggle::make('show_projects_section')->label('Show Projects')->inline(false),
                        Toggle::make('show_contact_section')->label('Show Contact')->inline(false),
                        Toggle::make('show_footer_section')->label('Show Footer')->inline(false),
                    ])
                    ->columns(3)
                    ->collapsible(), // allows collapsing this section
            ]);
        
            
        }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                
                // ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }
    public static function canCreate(): bool
{
    return false;
}


    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSectionsSettings::route('/'),
            // 'create' => Pages\CreateSectionsSetting::route('/create'),
            'edit' => Pages\EditSectionsSetting::route('/{record}/edit'),
        ];
    }
}
