<?php

namespace App\Filament\Resources\SectionsSettingResource\Pages;

use Filament\Resources\Pages\EditRecord;
use App\Filament\Resources\SectionsSettingResource;
use App\Models\WebsiteSetting;

class EditSectionsSetting extends EditRecord
{
    protected static string $resource = SectionsSettingResource::class;

    protected function getHeaderActions(): array
    {
        return []; // remove delete/create buttons
    }

    public function mount($record = null): void
    {
        // Always load the first WebsiteSetting record
        $this->record = WebsiteSetting::firstOrCreate(['id' => 1]);
        $this->fillForm();
    }

    /**
     * ✅ Fix redirect issue
     */
    protected function getRedirectUrl(): string
    {
        // Stay on the same edit page after save
        return $this->getResource()::getUrl('edit', ['record' => $this->record->getKey()]);
    }
}
